package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.Date;
import java.util.List;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
@DiscriminatorValue("2")
public class PersonTask extends Task {

	public static String CHANGE_REQUEST_TASK_STR = "Change to request is required by ";
	
	
	@ManyToOne
	@JoinColumn(name="personownerid")
	Person personOwner;
	
//TODO: verify that we're okay with a null groupCreator here too	
	@ManyToOne
	@JoinColumn(name="groupownerid")
	Group groupCreator;


	PersonTask(){
		super();
	}


	public static List<PersonTask> listByOwner(final int ownerId) {
		return DartObjectFactory.getInstance().getPersonTaskDAO().listByOwner(ownerId);
	}
	
	public static List<PersonTask> listOpenByOwner(final int ownerId) {
		return DartObjectFactory.getInstance().getPersonTaskDAO().listOpenByOwner(ownerId);
	}
	
	public static List<PersonTask> listAllPersonTasks() {
		return DartObjectFactory.getInstance().getPersonTaskDAO().listAllPersonTasks();
	}
	
	public static List<PersonTask> listAllOpenPersonTasks() {
		return DartObjectFactory.getInstance().getPersonTaskDAO().listAllOpenPersonTasks();
	}
	
	public static List<PersonTask> listOpenByRequestId(final int requestId) {
		return DartObjectFactory.getInstance().getPersonTaskDAO().listOpenByRequestId(requestId);
	}		
	
	public static List<PersonTask> listOpenByWorkflowAndRequestId(final int workflowId, final int requestId) {
		return DartObjectFactory.getInstance().getPersonTaskDAO().listOpenByWorkflowAndRequestId(workflowId, requestId);
	}		
	
	
	/**
	 * Creates a PersonTask entry with:
	 * 		a Person owner (who is this task assigned to?)
	 * 
	 * @param request
	 * @param owner
	 * @param name
	 * @param description
	 * @param createdby
	 * @return
	 * @throws ValidationException
	 */
	public static PersonTask create(final RequestWorkflow workflow, final Request request, final Person owner, final String name, final String description, final String createdby) throws ValidationException {

		ValidationHelper.required("Request", request);
		ValidationHelper.required("Created By", createdby);
		ValidationHelper.required("Owner", owner);
		
		PersonTask result = new PersonTask();
		result.createdBy = createdby;
		result.createdOn = new Date();
		
		result.modify(workflow, request, name, createdby);
		result.personOwner = owner;
		result.description = description;
		
		DartObjectFactory.getInstance().getPersonTaskDAO().save(result);
		
		return result;
	}

//TODO: I don't think we're using this version of PersonTask.create()
//	/**
//	 * Creates a PersonTask entry with:
//	 * 		a Person owner (who is this task assigned to?)
//	 * 		a Group createdByGroup (which group created this task?)
//	 * 
//	 * @param request
//	 * @param owner
//	 * @param createdByGroup
//	 * @param name
//	 * @param description
//	 * @param createdby
//	 * @return
//	 * @throws ValidationException
//	 */
//	public static PersonTask create(final RequestWorkflow workflow, final Request request, final Person owner, final Group createdByGroup, final String name, final String description, final String createdby) throws ValidationException {
//
//		ValidationHelper.required("Request", request);
//		ValidationHelper.required("Created By", createdby);
//		ValidationHelper.required("Created By Group", createdByGroup);
//		ValidationHelper.required("Owner", owner);
//		
//		PersonTask result = new PersonTask();
//		result.createdBy = createdby;
//		result.createdOn = new Date();
//		
//		result.modify(workflow, request, name, createdby);
//		result.personOwner = owner;
//		result.description = description;
//
//		result.groupCreator = createdByGroup;	//which group requested the change that resulted in this task?
//		
//		DartObjectFactory.getInstance().getPersonTaskDAO().save(result);
//		
//		return result;
//	}
	
	
	public Person getPersonOwner() {
		return personOwner;
	}
	
	public Group getGroupCreator() {
		return groupCreator;
	}
}
